/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.fluid;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidIngredientSerializer;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.List;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record FluidTagIngredient(class_6862<class_3611> tag, int amount) implements FluidIngredient
{
    @Override
    public boolean test(FluidStack stack) {
        return stack.isIn(this.tag);
    }

    @Override
    public List<class_3611> getMatchingFluids() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_6880 holder : class_7923.field_41173.method_40286(this.tag)) {
            class_3611 fluid = (class_3611)holder.comp_349();
            if (fluid instanceof class_3609) {
                class_3609 flowing = (class_3609)fluid;
                fluid = flowing.method_15751();
            }
            builder.add((Object)fluid);
        }
        return builder.build();
    }

    @Override
    public List<FluidStack> getMatchingFluidStacks() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_6880 holder : class_7923.field_41173.method_40286(this.tag)) {
            class_3611 fluid = (class_3611)holder.comp_349();
            if (fluid instanceof class_3609) {
                class_3609 flowing = (class_3609)fluid;
                fluid = flowing.method_15751();
            }
            builder.add((Object)new FluidStack(fluid, this.amount));
        }
        return builder.build();
    }

    @Override
    public FluidIngredientSerializer getSerializer() {
        return FluidIngredientSerializer.FLUID_TAG;
    }

    public record Serializer(String type) implements FluidIngredientSerializer
    {
        public static final MapCodec<FluidTagIngredient> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)class_6862.method_40093((class_5321)class_7924.field_41270).fieldOf("fluid_tag").forGetter(FluidTagIngredient::tag), (App)Codec.INT.optionalFieldOf("amount", (Object)81000).forGetter(FluidTagIngredient::amount)).apply((Applicative)i, FluidTagIngredient::new));
        public static final class_9139<class_9129, FluidTagIngredient> PACKET_CODEC = class_9139.method_56435((class_9139)class_6862.method_64143((class_5321)class_7924.field_41270), FluidTagIngredient::tag, (class_9139)class_9135.field_49675, FluidTagIngredient::amount, FluidTagIngredient::new);

        public MapCodec<FluidTagIngredient> codec() {
            return CODEC;
        }

        public class_9139<class_9129, FluidTagIngredient> packetCodec() {
            return PACKET_CODEC;
        }
    }
}

